################################################################################
#
# llama.cpp
#
################################################################################

LLAMA_CPP_VERSION = b6865
LLAMA_CPP_SOURCE = $(LLAMA_CPP_VERSION).tar.gz
LLAMA_CPP_SITE = https://github.com/ggml-org/llama.cpp/archive/refs/tags
LLAMA_CPP_LICENSE = MIT
LLAMA_CPP_LICENSE_FILES = LICENSE
LLAMA_CPP_CPE_ID_VENDOR = ggml
LLAMA_CPP_CPE_ID_PRODUCT = llama.cpp
LLAMA_CPP_INSTALL_STAGING = YES
LLAMA_CPP_CONF_OPTS = \
	-DLLAMA_BUILD_TESTS=OFF \
	-DLLAMA_BUILD_EXAMPLES=OFF \
	-DLLAMA_FATAL_WARNINGS=OFF

ifeq ($(BR2_PACKAGE_LIBEXECINFO),y)
LLAMA_CPP_DEPENDENCIES += libexecinfo
LLAMA_CPP_LDFLAGS += -lexecinfo
endif

ifeq ($(BR2_TOOLCHAIN_HAS_LIBATOMIC),y)
LLAMA_CPP_LDFLAGS += -latomic
endif

LLAMA_CPP_CONF_OPTS += \
	-DCMAKE_EXE_LINKER_FLAGS="$(LLAMA_CPP_LDFLAGS)"

ifeq ($(BR2_STATIC_LIBS),y)
LLAMA_CPP_CONF_OPTS += -DBUILD_SHARED_LIBS=OFF \
		       -DCMAKE_POSITION_INDEPENDENT_CODE=ON
endif

ifeq ($(BR2_PACKAGE_LIBCURL),y)
LLAMA_CPP_CONF_OPTS += -DLLAMA_CURL=ON
LLAMA_CPP_DEPENDENCIES += libcurl
else
LLAMA_CPP_CONF_OPTS += -DLLAMA_CURL=OFF
endif

ifeq ($(BR2_PACKAGE_LLAMA_CPP_TOOLS),y)
LLAMA_CPP_CONF_OPTS += -DLLAMA_BUILD_TOOLS=ON
else
LLAMA_CPP_CONF_OPTS += -DLLAMA_BUILD_TOOLS=OFF
endif

ifeq ($(BR2_PACKAGE_LLAMA_CPP_SERVER),y)
LLAMA_CPP_CONF_OPTS += -DLLAMA_BUILD_SERVER=ON
else
LLAMA_CPP_CONF_OPTS += -DLLAMA_BUILD_SERVER=OFF
endif

ifeq ($(BR2_PACKAGE_LLAMA_CPP_VULKAN),y)
LLAMA_CPP_DEPENDENCIES += vulkan-loader
LLAMA_CPP_CONF_OPTS += -DGGML_VULKAN=ON
else
LLAMA_CPP_CONF_OPTS += -DGGML_VULKAN=OFF
endif

ifeq ($(BR2_PACKAGE_OPENBLAS),y)
LLAMA_CPP_DEPENDENCIES += openblas
LLAMA_CPP_CONF_OPTS += -DGGML_BLAS=ON -DGGML_BLAS_VENDOR=OpenBLAS
else
LLAMA_CPP_CONF_OPTS += -DGGML_BLAS=OFF
endif

$(eval $(cmake-package))
